#!/bin/sh

saved_log_count=3
current_time=$(date "+%Y-%m-%d_%H_%M_%S")
serial_number=$(cat /etc/device/info1.gg | grep SerialNumber | cut -f2 -d'=')

savedlogs_path=/rw/savedlogs
compress_logs=/usr/local/bin/compress_logs.sh

if [ "$1" = "bootup" ]; then

    # Called on system bootup.

    if [ ! -d $savedlogs_path ]; then
        mkdir -p $savedlogs_path
    fi

    # Rename old "current_bootup" marker from last boot to "bootup". The point of doing this is to keep a
    # record of when the shutdown was not reached, where *current_bootup.log would have been removed and
    # replaced by the actual system logs. *current_bootup.log should be excluded when packaging the saved logs.
    rename current_bootup bootup ${savedlogs_path}/*.log > /dev/null 2>&1

    # Keep the logs from the 'saved_log_count' last reboots. 
    log_count=$(ls -l $savedlogs_path | grep -v backup | wc -l)

    if [ "$log_count" -gt "$saved_log_count" ]; then 
        ls -td $savedlogs_path/* | grep -v backup | tail -n $((log_count - saved_log_count)) | xargs rm
    fi

    # Create new "current_bootup" marker for this boot.
    touch ${savedlogs_path}/${serial_number}_${current_time}_current_bootup.log

elif [ "$1" = "shutdown" ]; then

    # Called on system shutdown.

    if [ -f $compress_logs ]; then

        mode="savelogs_ext"

        if [ -f /rw/config/extended_logging_at_shutdown.conf ]; then
            if [ "$(cat /rw/config/extended_logging_at_shutdown.conf)" = "0" ]; then
                mode="savelogs"
            fi
        fi

        $compress_logs $mode > /dev/null
        ret=$?

        if [ "$ret" != "0" ]; then
            echo "compress_logs failed: $ret"
            exit $ret
        fi

        # Delete the empty "current_bootup.log" marker file created at bootup. It has been replaced with the actual logs.
        rm -f $savedlogs_path/*current_bootup.log
    fi

elif [ "$1" = "backup" ]; then

    # Periodic log backup service.

    if [ -f $compress_logs ]; then

        $compress_logs backuplogs > /dev/null
        ret=$?

        backuplogs_path=$savedlogs_path/backup
        log_count=$(ls -l $backuplogs_path | wc -l)

        # Only keep the latest backup.
        if [ "$log_count" -gt "1" ]; then 
            ls -td $backuplogs_path/* | tail -n $((log_count - 1)) | xargs rm
        fi

        # sync to make sure the backup is fully commited in case we lose power.
        sync

        if [ "$ret" != "0" ]; then
            echo "compress_logs failed: $ret"
            exit $ret
        fi
    fi
fi

exit 0

